/*****************************************
* Klasse       : BuildTcpSegment
* Beschreibung : bildet ein TCP-Segment
*****************************************/
import TcpSegment;
import SessionControlBlock;
import java.util.Vector;

public class BuildTcpSegment {

protected TcpSegment segment[] = new TcpSegment[500];
protected int segmentcnt = 0;

/*****************************************
* Methode      : init
* Beschreibung : speichert Daten in einem Puffer
* Parameter    : Puffer , Daten  
* Rckgabewert : TcpSegment
*****************************************/
public final synchronized TcpSegment init(short lp, short dp, int mysqn){

       int k = segmentcnt;
       segmentcnt++;
       if ( k == 500 ) { k = 0; segmentcnt = 0;} else;
       segment[k] = new TcpSegment();
       segment[k].Lpnumb = lp; segment[k].Dpnumb = dp;
       segment[k].Seqnumb = mysqn;
       segment[k].SYN = 1;
       return segment[k];
}
/*****************************************
* Methode      : init
* Beschreibung : bildet ein TCP Segment
* Parameter    : short Lpnumb, short Dpnumb,    
* Rckgabewert : TcpSegment
*****************************************/
public final synchronized TcpSegment init(short lp, short dp, int mysqn, int yoursqn){

    int k = segmentcnt;
    segmentcnt++;
       if ( k == 500 ) { k = 0; segmentcnt = 0;} else;
       segment[k] = new TcpSegment();
       segment[k].Lpnumb = lp; segment[k].Dpnumb = dp;
       segment[k].Seqnumb = mysqn; segment[k].SYN = 1;
       segment[k].Acknumb = yoursqn + 1; segment[k].ACK = 1;
       return segment[k];}

public final synchronized TcpSegment initack(short lp, short dp, int mysndnxt, int myrcvnxt){

    int k = segmentcnt;
    segmentcnt++;
       if ( k == 500 ) { k = 0; segmentcnt = 0;} else;
       segment[k] = new TcpSegment();
       segment[k].Lpnumb = lp; segment[k].Dpnumb = dp;
       segment[k].Seqnumb = mysndnxt; segment[k].Acknumb = myrcvnxt;
       segment[k].ACK = 1;
       return segment[k];}

public final synchronized TcpSegment sendseg(short lp, short dp, int mysqn, int yoursqn, byte[] dat){

    int k = segmentcnt;
    segmentcnt++;
       if ( k == 500 ) { k = 0; segmentcnt = 0;} else;
       segment[k] = new TcpSegment();
       segment[k].Lpnumb = lp; segment[k].Dpnumb = dp;
       segment[k].Seqnumb = mysqn; segment[k].Acknumb = yoursqn + 1;
       segment[k].ACK = 1; segment[k].data = new byte[dat.length];
       segment[k].data = dat;
       return segment[k];}

public final synchronized TcpSegment closeseg(short lp, short dp, int mysqn, int yoursqn){

    int k = segmentcnt;
    segmentcnt++;
       if ( k == 500 ) { k = 0; segmentcnt = 0;} else;
       segment[k] = new TcpSegment();
       segment[k].Lpnumb = lp; segment[k].Dpnumb = dp;
       segment[k].Seqnumb = mysqn; segment[k].FIN = 1;
       segment[k].Acknumb = yoursqn + 1; segment[k].ACK = 1;
       return segment[k];}

public final synchronized TcpSegment closerst(short lp, short dp, int dublsqn){

    int k = segmentcnt;
    segmentcnt++;
       if ( k == 500 ) { k = 0; segmentcnt = 0;} else;
       segment[k] = new TcpSegment();
       segment[k].Lpnumb = lp; segment[k].Dpnumb = dp;
       segment[k].RST = 1; segment[k].Seqnumb = dublsqn;
       return segment[k];}

public final synchronized TcpSegment closerst(short lp, short dp, int yrsqn, byte[] dat){

       int k = segmentcnt;
        segmentcnt++;
       if ( k == 500 ) { k = 0; segmentcnt = 0;} else;
       segment[k] = new TcpSegment();
       segment[k].Lpnumb = lp; segment[k].Dpnumb = dp;
       segment[k].RST = 1; segment[k].Seqnumb = 0;
       segment[k].ACK = 1;
       segment[k].Acknumb = yrsqn + dat.length;
       return segment[k];}


  }
